#include "../../common/buffer.h"
#include "../../common/colors.h"
#include "../shaders.h"
#include <stdlib.h>

void blend_frame()
{
	unsigned char *ff, *bf;
	int x,y;
	color old_color;
	color new_color;

	ff = main_scene->frame_buffer;
	bf = main_scene->back_buffer;

	for(y = 0; y < main_scene->height; y++)
	{
		for(x = 0; x < main_scene->width; x++)
		{
			get_color(x, y, &new_color);
			//normalize_color(&new_color);

			main_scene->frame_buffer = bf;
			get_color(x, y, &old_color);
			set_color(x, y, &new_color);

			main_scene->frame_buffer = ff;
			new_color.r = new_color.r * 0.6 + old_color.r *0.4;
			new_color.g = new_color.g * 0.6 + old_color.g *0.4;
			new_color.b = new_color.b * 0.6 + old_color.b *0.4;
			///			if(x == 100)
			//				print_color(123, "", &new_color);
			//normalize_color(&new_color);
			set_color(x, y, &new_color);
		}
	}
}

